#ifndef BITMAP_HPP
#define BITMAP_HPP
#include "types.h"
/* The WindowBitmap class is used to maintain a bitmap copy of your
window for restoring it.  WindowBitmap uses a constructor that
takes an HWND as param.  To declare it globally, put at the top a global:
WindowBitmap *wbm;
then in WM_CREATE: put
	wbm = new WindowBitmap(hwnd, backgroundcolor);
backgroundcolor should be RGB(0,0,0) or RGB(255,255,255), depending on
whether your wndclass.hbrBackground is BLACK_BRUSH or WHITE_BRUSH.
In WM_PAINT: put
	hdc = BeginPaint(hwnd, &ps);
	wbm->CopyTo(hdc, ps.rcPaint);
	//Possible other screen writing
	EndPaint(hwnd, &ps);
In WM_DESTROY put
	delete wbm;
and to CLEAR the window put
	wbm->Clear();
	InvalidateRect(hwnd, NULL, FALSE);
Use the standard Windows API GUI calls to write graphics, except use
wbm->hdc() as the HDC argument.  Like, for instance,
	SetPixel(wbm->hdc(), x, y, col);
Whenever you finish a message case which does these writes to
the WindowBitmap, you do a
	InvalidateRect(hwnd, NULL, FALSE);
to BitBlt the altered WindowBitmap to the screen.*/

class WindowBitmap
{
private:
	HBITMAP _hbitmap;
	HDC _hdc;
	HBRUSH _hblankbrush;
	int _CX, _CY;
public:
	WindowBitmap(HWND hwnd, COLORREF blankcol); //constructor
	~WindowBitmap(); //destructor
	HDC hdc(){return _hdc;}
	void Clear();
	void CopyTo(HDC hdc, RECT rect);
};
#endif //BITMAP_HPP